/*
 * Decompiled with CFR 0.152.
 */
package com.dodgeman.shw.client.commands;

import com.dodgeman.shw.client.commands.CommandLineFormatter;
import com.dodgeman.shw.config.ShwConfigWrapper;
import com.dodgeman.shw.saveddata.SetHomeAndWaypointsSavedData;
import com.dodgeman.shw.saveddata.SetHomeWaypointsSavedDataFactory;
import com.dodgeman.shw.saveddata.models.Home;
import com.dodgeman.shw.saveddata.models.PlayerHomeAndWaypoints;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class HomeCommand {
    public static final String COMMAND_NAME = "home";
    public static final String COMMAND_CONFIG_NAME = "config";
    public static final int TRAVEL_THROUGH_DIMENSION_FAILURE = -1;
    public static final int COOLDOWN_NOT_READY_FAILURE = -2;
    private static final int NO_HOME_FOUND_FAILURE = -3;
    public static final String COMMAND_COOLDOWN_NAME = "cooldown";
    public static final String ARG_NAME_FOR_COOLDOWN = "cooldownValue";
    public static final String COMMAND_DIMENSIONAL_TRAVEL_NAME = "dimensionalTravel";
    public static final String ARG_NAME_FOR_DIMENSIONAL_TRAVEL = "dimensionalTravelValue";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_NAME).requires(CommandSourceStack::m_230897_)).executes(HomeCommand::goHome)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_CONFIG_NAME).executes(HomeCommand::showConfiguration)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_COOLDOWN_NAME).requires(stack -> stack.m_6761_(3))).then(Commands.m_82129_((String)ARG_NAME_FOR_COOLDOWN, (ArgumentType)IntegerArgumentType.integer((int)0)).executes(HomeCommand::configureCooldown)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_DIMENSIONAL_TRAVEL_NAME).requires(stack -> stack.m_6761_(3))).then(Commands.m_82129_((String)ARG_NAME_FOR_DIMENSIONAL_TRAVEL, (ArgumentType)BoolArgumentType.bool()).executes(HomeCommand::configureDimensionalTravel)))));
    }

    private static int goHome(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        Home currentHome = playerHomeAndWaypoints.getHome();
        if (currentHome == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"shw.commands.home.error.homeNotFound", (Object[])new Object[]{CommandLineFormatter.formatCommand("sethome")}));
            return -3;
        }
        ServerLevel serverLevel = player.f_8924_.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(currentHome.position().dimension())));
        if (!ShwConfigWrapper.isDimensionalTravelAllowedForHome() && !player.m_9236_().m_46472_().equals((Object)serverLevel.m_46472_())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"shw.commands.home.error.dimensionalTravelNotAllowed"));
            return -1;
        }
        long cooldownRemaining = TimeUnit.SECONDS.toMillis(ShwConfigWrapper.getHomeCooldown()) - playerHomeAndWaypoints.elapsedTimeOfLastHomeCommandExecution();
        if (cooldownRemaining > 0L) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"shw.commands.home.error.cooldown", (Object[])new Object[]{TimeUnit.MILLISECONDS.toSeconds(cooldownRemaining) + 1L}));
            return -2;
        }
        player.m_8999_(serverLevel, currentHome.position().x(), currentHome.position().y(), currentHome.position().z(), currentHome.position().ry(), currentHome.position().rx());
        playerHomeAndWaypoints.homeCommandHasBeenExecuted();
        savedData.m_77762_();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"shw.commands.home.success"), false);
        return 1;
    }

    private static int showConfiguration(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"shw.commands.home.config.success", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(ShwConfigWrapper.getHomeCooldown())).m_130940_(ChatFormatting.BLUE), CommandLineFormatter.formatPermitted(ShwConfigWrapper.isDimensionalTravelAllowedForHome())}), false);
        return 1;
    }

    private static int configureCooldown(CommandContext<CommandSourceStack> context) {
        int cooldownValue = IntegerArgumentType.getInteger(context, (String)ARG_NAME_FOR_COOLDOWN);
        ShwConfigWrapper.setHomeCooldown(cooldownValue);
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            player.m_213846_((Component)Component.m_237110_((String)"shw.commands.home.config.cooldown.success", (Object[])new Object[]{CommandLineFormatter.formatCommand(COMMAND_NAME), Component.m_237113_((String)String.valueOf(cooldownValue))}).m_130940_(ChatFormatting.GRAY));
        }
        return 1;
    }

    private static int configureDimensionalTravel(CommandContext<CommandSourceStack> context) {
        boolean dimensionalTravel = BoolArgumentType.getBool(context, (String)ARG_NAME_FOR_DIMENSIONAL_TRAVEL);
        ShwConfigWrapper.setAllowDimensionalTravelForHome(dimensionalTravel);
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            player.m_213846_((Component)Component.m_237110_((String)"shw.commands.home.config.dimensionalTravel.success", (Object[])new Object[]{CommandLineFormatter.formatCommand(COMMAND_NAME), Component.m_237113_((String)String.valueOf(dimensionalTravel))}).m_130940_(ChatFormatting.GRAY));
        }
        return 1;
    }
}

